#include <windows.h>
#include "WindowsMessageMap.h"
#include <sstream>

// we need to have our own WndProc since DefWndProc is shit, we cannot even close a window:
LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) { // NOLINT
    static WindowsMessageMap mm;
    // the windows will fill in the msg, wParam and lParam -> see them in lldb
    OutputDebugString(mm(msg, lParam, wParam).c_str());

    static std::string title;
    std::ostringstream oss;

    switch (msg) {
        case WM_CLOSE:
            PostQuitMessage(69); // this will post a quit message on message queue, here 69 is for demo
            break;
        case WM_KEYDOWN: // in KEYDOWN doc tells what wParam is,
            // this one does not have notion for captial letters or not
            if (wParam == 'F') {
                SetWindowTextA(hwnd,"Hello World");
            }
            break;

        case WM_CHAR: // getting a 'd' or 'D' depends on the state of shift, this part is used in translating messages
            // otherwise its check keyboard input letters including enter (not F1-F12)
            // WM_CHAR is only generated when a key press translates into actual printable or control character
            // it will also check keyboard state, like press shift + 'A' the translate message will queue an 'A' in message queue
            title.push_back(static_cast<char>(wParam));
            SetWindowTextA(hwnd,title.c_str());

            break;

        case WM_LBUTTONDOWN: // doc says lParam has point info
            POINTS pt = MAKEPOINTS(lParam);
            oss << "(" << pt.x << "," << pt.y << ")";
            SetWindowTextA(hwnd,oss.str().c_str());

        default:
            break;
    }

    return DefWindowProc(hwnd, msg, wParam, lParam); // since the last step for a message loop is DefWindowProc
}


// for the four parameters, the lpCmdLine will be the most important, when people app with command line and pass
// extra parameters, it will be useful
// the CALLBACK here will tell cpp use a different calling convention which is stdcall
int CALLBACK WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpCmdLine,
    int nShowCmd) {

    const auto pClassName = "dx11LearnMain";

    // fill the "registration table":
    WNDCLASSEXA wc = {0};

    wc.cbSize = sizeof(WNDCLASSEXA);
    wc.style = CS_OWNDC;
    wc.lpfnWndProc = WndProc;
    // we don't need extra data:
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = nullptr;
    wc.hCursor = nullptr;
    wc.hbrBackground = nullptr;
    wc.lpszMenuName = nullptr;
    wc.lpszClassName = pClassName;
    wc.hIconSm = nullptr;

    // first, we register window class: Ex for api functions means extended
    RegisterClassEx(&wc);

    // now we create the window, we need to save the window's handle for other operations:
    // the create window function only set up the window initial info
    HWND hwnd = CreateWindowEx(0, pClassName, "DirectX 11 Learn",
        WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU, 200, 200,
        640, 480, nullptr, nullptr, hInstance, nullptr);

    // we need to show the window so it can display on the screen:
    ShowWindow(hwnd, SW_SHOW); // SW_SHOW activate the window and display at target position

    // message pump
    MSG msg;

    BOOL gResult; // none cpp BOOL

    // continue to process messages:
    // GetMessage function will automatically fill in the msg structure since we pass a pointer 
    while ((gResult = GetMessage(&msg, nullptr, 0, 0)) > 0) {
        TranslateMessage(&msg);
        DispatchMessage(&msg); // send the message to WndProc
    }

    if (gResult == -1) {
        return -1;
    } else {
        return msg.wParam;
    }

}